#include <Wire.h>                 // bibliothèque I2C
#include <rgb_lcd.h>              // pour l'afficheur
rgb_lcd lcd;                      // création de l'objet afficheur nommé lcd

//variables :
float distance;
int temps; 
float celerite = 339.5;                 // vitesse du son, en m/s

void setup()
{
lcd.begin(16, 2);                       // configure l'afficheur 16 lignes 2 colonnes
lcd.clear();                            // nettoyage de l'écran
lcd.print("Distance =");                // affichage 1ère ligne
}

void loop(){

//émission et réception de l'onde :
pinMode(4, OUTPUT);    
digitalWrite(4, HIGH); 
delayMicroseconds(10);   
digitalWrite(4, LOW);  
pinMode(4, INPUT);     

//calculs :
temps = pulseIn(4, HIGH);               // durée aller-retour, en μs, de l'onde
distance = celerite*temps*0.000001/2;   // calcul de la distance, en m

//affichage :

lcd.setRGB(255, 255, 255);              // couleur du rétroéclairage (blanc)

lcd.setCursor(5, 1);                    // placement curseur 2e ligne
lcd.print(distance);                    // affichage de la distance
lcd.print(" m");
delay(500);                             // mesure de distance toutes les 500 ms 


}
